
import React, { useState } from 'react';
import { motion } from 'framer-motion';
import { Button } from '@/components/ui/button';
import { RefreshCw, ArrowLeft, Package } from 'lucide-react';
import InventoriForm from '@/components/InventoriForm';
import InventoriTable from '@/components/InventoriTable';

const InventoriPage = ({ onBack }) => {
  const [selectedBarang, setSelectedBarang] = useState(null);
  const [refreshTrigger, setRefreshTrigger] = useState(0);

  const handleEdit = (barang) => {
    setSelectedBarang(barang);
    window.scrollTo({ top: 0, behavior: 'smooth' });
  };

  const handleSuccess = () => {
    setSelectedBarang(null);
    setRefreshTrigger(prev => prev + 1);
  };

  const handleCancel = () => {
    setSelectedBarang(null);
  };

  const handleRefresh = () => {
    setRefreshTrigger(prev => prev + 1);
  };

  return (
    <div className="space-y-6">
      <motion.div
        initial={{ opacity: 0, y: -10 }}
        animate={{ opacity: 1, y: 0 }}
        className="flex items-center justify-between"
      >
        <div className="flex items-center gap-4">
          {onBack && (
            <Button variant="ghost" size="icon" onClick={onBack} className="text-blue-100 hover:text-white hover:bg-blue-800">
              <ArrowLeft className="h-6 w-6" />
            </Button>
          )}
          <div>
            <h1 className="text-2xl font-bold text-white flex items-center gap-2">
              <Package className="h-6 w-6" />
              Inventori Barang
            </h1>
            <p className="text-blue-200 text-sm">Kelola stok dan harga barang</p>
          </div>
        </div>
      </motion.div>

      <motion.div
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.3 }}
      >
        <InventoriForm
          selectedBarang={selectedBarang}
          onSuccess={handleSuccess}
          onCancel={handleCancel}
        />
      </motion.div>

      <motion.div
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.3, delay: 0.1 }}
        className="flex justify-end"
      >
        <Button
          onClick={handleRefresh}
          variant="outline"
          className="border-blue-300 text-blue-600 hover:bg-blue-50"
        >
          <RefreshCw className="h-4 w-4 mr-2" />
          Refresh Data
        </Button>
      </motion.div>

      <motion.div
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.3, delay: 0.2 }}
      >
        <InventoriTable
          onEdit={handleEdit}
          refreshTrigger={refreshTrigger}
        />
      </motion.div>
    </div>
  );
};

export default InventoriPage;
