
-- BAKULAN NDESO Database Schema
-- Run these SQL commands in your Supabase SQL Editor
-- Dashboard > SQL Editor > New Query

-- ==============================================
-- STEP 1: Create inventori table
-- ==============================================
CREATE TABLE IF NOT EXISTS inventori (
  id UUID DEFAULT gen_random_uuid() PRIMARY KEY,
  nama_barang TEXT NOT NULL,
  harga DECIMAL(15, 2) NOT NULL CHECK (harga >= 0),
  stok INTEGER NOT NULL DEFAULT 0 CHECK (stok >= 0),
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);

-- Create index for faster queries
CREATE INDEX IF NOT EXISTS idx_inventori_nama_barang ON inventori(nama_barang);

-- Create updated_at trigger function
CREATE OR REPLACE FUNCTION update_updated_at_column()
RETURNS TRIGGER AS $$
BEGIN
  NEW.updated_at = NOW();
  RETURN NEW;
END;
$$ LANGUAGE plpgsql;

-- Create trigger for inventori table
DROP TRIGGER IF EXISTS update_inventori_updated_at ON inventori;
CREATE TRIGGER update_inventori_updated_at
  BEFORE UPDATE ON inventori
  FOR EACH ROW
  EXECUTE FUNCTION update_updated_at_column();

-- ==============================================
-- STEP 2: Create transaksi table
-- ==============================================
CREATE TABLE IF NOT EXISTS transaksi (
  id UUID DEFAULT gen_random_uuid() PRIMARY KEY,
  barang_id UUID NOT NULL REFERENCES inventori(id) ON DELETE RESTRICT,
  jumlah INTEGER NOT NULL CHECK (jumlah > 0),
  harga_satuan DECIMAL(15, 2) NOT NULL CHECK (harga_satuan >= 0),
  total_harga DECIMAL(15, 2) NOT NULL CHECK (total_harga >= 0),
  tanggal_transaksi TIMESTAMP WITH TIME ZONE NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);

-- Create indexes for faster queries
CREATE INDEX IF NOT EXISTS idx_transaksi_barang_id ON transaksi(barang_id);
CREATE INDEX IF NOT EXISTS idx_transaksi_tanggal ON transaksi(tanggal_transaksi DESC);

-- ==============================================
-- STEP 3: Create pelanggan table
-- ==============================================
CREATE TABLE IF NOT EXISTS pelanggan (
  id UUID DEFAULT gen_random_uuid() PRIMARY KEY,
  nama_pelanggan TEXT NOT NULL,
  nomor_telepon TEXT NOT NULL,
  alamat TEXT NOT NULL,
  email TEXT,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);

-- Create indexes for faster queries
CREATE INDEX IF NOT EXISTS idx_pelanggan_nama ON pelanggan(nama_pelanggan);
CREATE INDEX IF NOT EXISTS idx_pelanggan_telepon ON pelanggan(nomor_telepon);

-- Create trigger for pelanggan table
DROP TRIGGER IF EXISTS update_pelanggan_updated_at ON pelanggan;
CREATE TRIGGER update_pelanggan_updated_at
  BEFORE UPDATE ON pelanggan
  FOR EACH ROW
  EXECUTE FUNCTION update_updated_at_column();

-- ==============================================
-- STEP 4: Enable Row Level Security (RLS)
-- ==============================================
-- Enable RLS on all tables
ALTER TABLE inventori ENABLE ROW LEVEL SECURITY;
ALTER TABLE transaksi ENABLE ROW LEVEL SECURITY;
ALTER TABLE pelanggan ENABLE ROW LEVEL SECURITY;

-- Create policies to allow all operations (adjust based on your needs)
-- For development: allow all operations
DROP POLICY IF EXISTS "Enable all operations for inventori" ON inventori;
CREATE POLICY "Enable all operations for inventori" ON inventori
  FOR ALL USING (true) WITH CHECK (true);

DROP POLICY IF EXISTS "Enable all operations for transaksi" ON transaksi;
CREATE POLICY "Enable all operations for transaksi" ON transaksi
  FOR ALL USING (true) WITH CHECK (true);

DROP POLICY IF EXISTS "Enable all operations for pelanggan" ON pelanggan;
CREATE POLICY "Enable all operations for pelanggan" ON pelanggan
  FOR ALL USING (true) WITH CHECK (true);

-- ==============================================
-- INSTRUCTIONS:
-- ==============================================
-- 1. Go to your Supabase Dashboard (https://app.supabase.com)
-- 2. Select your project
-- 3. Navigate to SQL Editor (left sidebar)
-- 4. Click "New Query"
-- 5. Copy and paste this entire SQL script
-- 6. Click "Run" or press Ctrl+Enter (Cmd+Enter on Mac)
-- 7. Verify tables are created in Table Editor
-- 8. Update your .env file with Supabase credentials
-- ==============================================
